//*********************************************************************
//
//    FAT16 MMC/SD   1.10.
// 
// 1.  makefile.mak  .  
//    Project ->Configuration options. 
//      General   Use external makefile. 
//     ""  makefile.mak.
//
// 2.  makefile.mak    : 
//    MCU -  
//    F_CPU -   
//    BOOTLDRSIZE -   
//    BOOTLOADERSTARTADR -   
//    TARGET -  *.hex ,   
//    OBJDIR - ,     
//
// 3.  mmc.h  ,    
//    (. makefile.mak,  MCU)  ,   
//     SD .  SPI_DI, SPI_DO, SPI_Clock   
//       SPI ..   SPI 
//    .  MMC_Chip_Select  SPI_SS   
//       . 
//     SD  MMC_Chip_Select  = SPI_SS.
//
// 4.  megavar.h,    , 
//     EEPROM  FLASH     : 
//    EE_SECTOR_FOR_READ  FL_SECTOR_FOR_READ  EEPROM  FLASH 
//    . 
// 
// 5.  main.   int main(void)    
//    bootloader-a (    PINC).    
//        "boot" (  loadboot()).
// 
// 6. SD       FAT16. 
//	    512 .
//        bin- EEPROM  FLASH. 
//     "boot.ee"  "boot.fl"   EEPROM - "ee", 
//     FLASH - "fl".  EEPROM  . 
//     FLASH   .   -  
//      EE_SECTOR_FOR_READ*512  FL_SECTOR_FOR_READ*512 
//     EEPROM  FLASH .
// 
// 7.     
//    progeeprom32.bat ( )  
//    progHfuse32.bat ( ). 
//       usbasp 
//      .
//
// 8.       matrex@rambler.ru.
// 
// 9.      :
//    http://www.mikrocontroller.net/articles/MMC/SD_Bootloader_f%C3%BCr_AT_Mega
//    http://www.ulrichradig.de/home/index.php/avr/mmc-sd
//    http://www.dharmanitech.com/2009/01/sd-card-interfacing-with-atmega8-fat32.html
//
//
//     :
//
//    01.10.2011 v. 1.01.
//        EEPROM   ATMEGA32. 
//           
//    .    EEPROM .
//
//    08.12.2011 v. 1.10.
//       :
//		-      ( )
//		    "boot.fl" "boot.ee"
//		-     "upload.bat"   
//		  ,    upload,   - 
//		      " ", 
//		  zagrus(#0D)(#0A)
//
//*********************************************************************



#include <util/delay.h>

#include <avr/boot.h>
#include <inttypes.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include "mmc.h"
#include "fat.h"
#include "megavar.h"

#define cPathSIze 32 //     
void (*app_start)(void) = 0x0000;






void upload(char *filename, unsigned char memtype)
{
	unsigned int tmp;
	unsigned int Clustervar=0;
	unsigned char Dir_Attrib = 0;
	unsigned long Size = 0;
	unsigned char Buffer[512];
	uint16_t filesector, j, ii, adr, *lpword;
	uint8_t i;
	if (fat_search_file(filename,&Clustervar,&Size,&Dir_Attrib,Buffer) != 1) return; //  
	switch (memtype) //    
	{
	case 0:
		//  FLASH
		for (filesector = 0; filesector < FL_SECTOR_FOR_READ ; filesector++)
		{
		lpword = (uint16_t*) Buffer;
		fat_read_file (Clustervar,Buffer,filesector);
		for (i=0; i<(512 / SPM_PAGESIZE); i++)
			{
			adr = (filesector * 512) + i * SPM_PAGESIZE;
//			if (adr>=Size) break;
			boot_page_erase(adr);
			while (boot_rww_busy())
				boot_rww_enable();
			for (j=0; j<SPM_PAGESIZE; j+=2)
				boot_page_fill(adr + j, *lpword++);
			boot_page_write(adr);
			while (boot_rww_busy())
				boot_rww_enable();
			}; 
		 };
		 break;


	default:
		//  EEPROM
		adr=0;
		for (filesector = 0; filesector < EE_SECTOR_FOR_READ; filesector++)
		{
		fat_read_file (Clustervar,Buffer,filesector);
			for(ii=0;ii<512;ii++)
			{
//				if (adr==Size) break;	
				eeprom_busy_wait();
				eeprom_write_byte(adr, Buffer[ii]);
				adr++;
			}
		};
	    break;
	}
}





unsigned char uploadfilename(char *filename, char *load)
{
	unsigned int Clustervar=0;
	unsigned char Dir_Attrib = 0;
	unsigned long Size = 0;
	unsigned char Buffer[512], ii;
	if (fat_search_file(filename,&Clustervar,&Size,&Dir_Attrib,Buffer) != 1) return 1; //  
	fat_read_file (Clustervar,Buffer,0);
			for(ii=0;ii<cPathSIze;ii++)
			{
				if (Buffer[ii]<33) return 0;
				load[ii]=Buffer[ii];
			//	eeprom_write_byte(ii, Buffer[ii]);
			}
	return 0;
}




void loadboot()
{
char filename[]="boot";     //  ,     
char f[cPathSIze];
char f1[cPathSIze];
char ee=".ee";
char fl=".fl";
cli();						//  
if (mmc_init() !=0) return; //    
fat_init();
memset(f,0,sizeof(f));
memset(f1,0,sizeof(f1));
memcpy(f,filename,strlen(filename));
strcat(f,fl);
memcpy(f1,filename,strlen(filename));
strcat(f1,ee);
upload(f,0); 				//  FLASH
upload(f1,1); 				//  EEPROM
}



void loadfile()
{
char fn[]="upload.bat";     	//  ,     
char filename[cPathSIze];				//   
char f[cPathSIze];
char f1[cPathSIze];

char ee=".ee";
char fl=".fl";


cli();						//  
if (mmc_init() !=0) return; //    
fat_init();					//  FAT16
memset(filename,0,sizeof(filename));					
if (uploadfilename(fn,filename)!=0) return; //   
//for(unsigned char u=0;u<sizeof(nn);u++) {eeprom_write_byte(u+32, filename[u]);}
memset(f,0,sizeof(f));
memset(f1,0,sizeof(f1));
memcpy(f,filename,strlen(filename));
strcat(f,fl);
memcpy(f1,filename,strlen(filename));
strcat(f1,ee);
upload(f,0); 				//  FLASH
upload(f1,1); 				//  EEPROM

}


int main(void)
{
 _delay_ms(10);
 PORTC = 0xFF; 	//pullup for keys
 DDRC  = 0x00;	// x x x START ROTATE LEFT RIGHT DOWN
  _delay_ms(10);
if(PINC!=255) 				//   bootloader- (  VK1)
    {
	loadboot();   			//  
	}
	else
	{
	loadfile();					//    
	}
app_start();				//  
}




